#include "_utils.fx"

//--------------------------------------------------------------
// Header
//
// Specify the name, category, subcategory, notes & flags
//--------------------------------------------------------------
DeclareLightworksEffect( ( "Lift, Gamma, Gain" ), "Colour", "User", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Inputs
//
// For each input declared here, Lightworks adds a matching
// input to your effect.
//--------------------------------------------------------------

DeclareInput( Input );

//--------------------------------------------------------------
// Define parameters here.
//
// The Lightworks application will automatically generate
// sliders/controls for all parameters that are declared here
//--------------------------------------------------------------
DeclareFloatParam( MasterLift,  "Lift",  "Master", kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( MasterGamma, "Gamma", "Master", kNoFlags, 1.0,  0.1, 4.0 );
DeclareFloatParam( MasterGain,  "Gain",  "Master", kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( RedLift,     "Lift",  "Red",    kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( RedGamma,    "Gamma", "Red",    kNoFlags, 1.0,  0.1, 4.0 );
DeclareFloatParam( RedGain,     "Gain",  "Red",    kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( GreenLift,   "Lift",  "Green",  kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( GreenGamma,  "Gamma", "Green",  kNoFlags, 1.0,  0.1, 4.0 );
DeclareFloatParam( GreenGain,   "Gain",  "Green",  kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( BlueLift,    "Lift",  "Blue",   kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( BlueGamma,   "Gamma", "Blue",   kNoFlags, 1.0,  0.1, 4.0 );
DeclareFloatParam( BlueGain,    "Gain",  "Blue",   kNoFlags, 0.0, -1.0, 1.0 );

//--------------------------------------------------------------
// Pixel Shader
//
// This section defines the code which the GPU will
// execute for every pixel in an output image.
//
// Note that pixels are processed out of order, in parallel
//--------------------------------------------------------------
DeclareEntryPoint()
{
   // Read a pixel from the source image at position 'uv'
   // and place it in the variable 'source'
   float4 source = tex2D( Input, uv1 );

   // Set up compound RGBA variables from the user-specified channel parameters
   float4 gamma = float4( RedGamma, GreenGamma, BlueGamma , 1.0 );
   float4 lift  = float4( RedLift,  GreenLift,  BlueLift,   1.0 );
   float4 gain  = float4( RedGain,  GreenGain,  BlueGain,   1.0 );

   gamma.rgb += MasterGamma - 1;
   lift.rgb  += MasterLift;
   gain.rgb  += MasterGain + 1;

   // Clamp the values.  Would be nice to use clamp()/saturate() here, but the
   // run-time FX compiler in VS2005 will fail if you do.  Nice.
   if ( gamma.r < 0.1 ) gamma.r = 0.1;
   if ( gamma.g < 0.1 ) gamma.g = 0.1;
   if ( gamma.b < 0.1 ) gamma.b = 0.1;

   // Perform the correction
   float4 corrected = pow( source, 1 / gamma ) * gain;
   corrected += ( 1 - corrected ) * lift;

   // Honour source alpha
   corrected = lerp( source, corrected, source.a );
   corrected.a = source.a;

   return corrected;
}
